PROGRAM test_mat_inv
!
!  Purpose:
!    To illustrate the use of library subroutine mat_inv, and  
!    also to illustrate the errors caused by passing incorrect
!    array sizes to mat_inv.
!
!  Record of revisions:
!      Date       Programmer          Description of change
!      ====       ==========          =====================
!    03/04/96    S. J. Chapman        Original code
!
USE booklib                     ! Use BOOKLIB library
IMPLICIT NONE

! List of variables:
REAL, DIMENSION(4,4) :: a       ! Input matrix
REAL, DIMENSION(4,4) :: b       ! Output matrix
INTEGER :: error                ! Error flag
INTEGER :: i, j                 ! Index variables
INTEGER :: n                    ! Actual size of matrix to invert
INTEGER :: ndim                 ! Declared size of a & b

a = RESHAPE ((/1.,2.,3.,0.,1.,3.,2.,0.,-1.,2.,-3.,0.,0.,0.,0.,0./),&
             (/4,4/))
b = 0.

! Call mat_inv subroutine correctly to invert 3 x 3 matrix a
! and place the result in b.
ndim = 4
n = 3
CALL mat_inv ( a, b, ndim, n, error )

! Print out matrix a.
WRITE (*,'(/1X,A)') 'Matrix a:'
WRITE (*,'(3X,4F10.4)') ((a(i,j), j=1,4), i=1,4)

! Print out matrix b.
WRITE (*,'(/1X,A)') 'Result with matrix sizes declared correctly:'
WRITE (*,'(3X,4F10.4)') ((b(i,j), j=1,4), i=1,4)
WRITE (*,'(1X,A,I2)') 'Error flag = ', error

! Call mat_inv subroutine with all parameters equal to 3.  
b = 0.                               ! Clear b
ndim = 3                             ! Error 
n = 3
CALL mat_inv ( a, b, ndim, n, error )

! Print out matrix b.
WRITE (*,'(/1X,A)') 'Result with matrix sizes declared incorrectly:'
WRITE (*,'(3X,4F10.4)') ((b(i,j), j=1,4), i=1,4)
WRITE (*,'(1X,A,I2)') 'Error flag = ', error

END PROGRAM
